### Overview: What Are Policies?

- **Purpose:**  
    Policies control how Cisco Secure Network Analytics monitors and responds to host behavior on the network.
- **Function:**  
    Each policy defines settings for how the system reacts to observed behaviors.

---

### Types of Policies

1. **Default Policies**
    
    - Apply to all Inside Hosts or all Outside Hosts by default.
    - Two predefined policies: Inside Hosts default policy and Outside Hosts default policy.
    - Can be edited but not deleted.
    - Used when no specific role or host policy is configured for a host.
2. **Role Policies**
    
    - Apply to groups of hosts with a common purpose (e.g., web servers, firewalls).
    - Take precedence over default policies.
    - Can be assigned to one or more host groups or IP address ranges.
3. **Host Policies**
    
    - Apply to a specific IP address (host).
    - Highest priority—override both role and default policies.
    - Each host can have only one host policy.

---

### Policy Management

- **Where to Manage:**
    - Desktop Client (any version)
    - WebUI (version 7.0 and later)
- **How to Access:**
    - In Desktop Client: Configuration > Host Policy Manager

---

### Policy Inheritance & Precedence

- **Order of Precedence:**
    1. Host Policy (highest)
    2. Role Policy
    3. Default Policy (lowest)
- **Inheritance:**
    - If a host has no specific host or role policy, it inherits the default (inside or outside) policy.

---

### Policy Configuration Options

- **Customizable Settings:**
    - Enable/disable individual alarm categories.
    - Enable/disable specific security events.
    - Adjust thresholds for alarms.
- **Example:**
    - Address Scan/tcp event:
        - Enabled in the default Inside Hosts policy (all Inside Hosts will trigger on scan activity).
        - Disabled in the Network Management & Scanners role policy (hosts in Network Scanners group will not trigger this event).

---

### Editing Policies

- **Edit in Desktop Client or WebUI:**
    - Enable or disable alarm categories and security events for any policy.
    - Assign policies to host groups or specific hosts as needed.

---

### Key Points

- **Default policies apply unless overridden by role or host policies.**
- **Role and host policies provide granular control for specialized groups or individual hosts.**
- **Settings in higher-precedence policies always override lower-precedence ones.**
- **Both Desktop Client and WebUI provide full policy management capabilities.**